<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

jimport('joomla.form.formfield');

class JFormFieldJcat extends JFormField {

	protected	$_name = 'jcat';

	protected function getInput()	{
		$db	= JFactory::getDBO();
		$q = "SELECT id, title, parent_id FROM #__categories WHERE extension='com_content' AND published=1 ORDER BY parent_id,title";
		$db->setquery($q);
		$cats=$db->loadObjectList();

		foreach ( $cats as $v ) {
			$pt = $v->parent_id;
			$list = @$children[$pt] ? $children[$pt] : array();
			array_push( $list, $v );
			$children[$pt] = $list;
		}

		$list = JHTML::_('menu.treerecurse', 1, '', array(), $children, 9999, 0, 0 );
		$mitems = array(JHTML::_('select.option', '0', 'ALL CATEGORIES' ));
		foreach ( $list as $item ) {
			$mitems[] = JHTML::_('select.option',  $item->id, '   '.$item->treename );
		}

		$size = count($mitems);
		//$size = ceil($size/10);
		if ($size < 5) $size = 5;
		if ($size > 20) $size = 20;
		
		return JHTML::_('select.genericlist', $mitems, $this->name . '[]', 'class="inputbox" multiple="multiple" size="' . $size . '"', 'value', 'text', $this->value);
	}
}