<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

jimport('joomla.form.formfield');

class JFormFieldK2cat extends JFormField {

	protected	$_name = 'k2cat';

	protected function getInput()	{
		$db	= JFactory::getDBO();
		$q = "SELECT id, name as title, parent as parent_id FROM #__k2_categories WHERE trash=0 AND published=1 ORDER BY parent,ordering,name";
		$db->setquery($q);
		$cats=$db->loadObjectList();

		foreach ( $cats as $v ) {
			$pt = $v->parent_id;
			$list = @$children[$pt] ? $children[$pt] : array();
			array_push( $list, $v );
			$children[$pt] = $list;
		}

		$list = JHTML::_('menu.treerecurse', 0, '', array(), $children, 9999, 0, 0 );
		$mitems = array(JHTML::_('select.option', '0', 'ALL CATEGORIES' ));

		foreach ( $list as $item ) {
			$mitems[] = JHTML::_('select.option',  $item->id, '   '.$item->treename );
		}

		$size = count($mitems);
		//$size = ceil($size/10);
		if ($size < 5) $size = 5;
		if ($size > 20) $size = 20;
		
		return JHTML::_('select.genericlist', $mitems, $this->name . '[]', 'class="inputbox" multiple="multiple" size="' . $size . '"', 'value', 'text', $this->value);
	}
}