<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

jimport('joomla.form.formfield');

class JFormFieldK2item extends JFormField {

	protected	$_name = 'k2item';

	protected function getInput()	{

		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$doc = JFactory::getDocument();

		JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_k2/tables');
		$item = JTable::getInstance('K2Item','Table');

		if ($this->value) {
			$item->load($this->value);
		}
		else {
			$item->title = JText::_('JXTCTIMELINE_K2SELECTITEM');
		}

		$js = "
		function jSelectItem(id, title, object) {
			document.getElementById('".$this->id."' ).value = id;
			document.getElementById('".$this->id."' + '_name').value = title;
			window.parent.SqueezeBox.close();
		}
		";

		$doc->addScriptDeclaration($js);

		$link = 'index.php?option=com_k2&amp;view=items&amp;task=element&amp;tmpl=component&amp;object='.$this->name;

		JHTML::_('behavior.modal', 'a.modal');

		$html	= '';
		// The current user display field.
		$html .= '
		<div class="input-append">
			<input type="text" id="'.$this->id.'_name" value="'.htmlspecialchars($item->title, ENT_QUOTES, 'UTF-8').'" disabled="disabled" size="35" />
			<a class="modal btn" title="'.JText::_('JXTCTIMELINE_K2SELECTITEM').'"  href="'.$link.'&amp;'.JSession::getFormToken().'=1" rel="{handler: \'iframe\', size: {x: 800, y: 450}}"><i class="icon-search"></i></a>
      <button class="btn" type="button" onclick="document.getElementById(\''.$this->id.'_name\').value=\'\';document.getElementById(\''.$this->id.'\').value=0;" title="'.JText::_('JXTCTIMELINE_CLEAR').'"><i class="icon-delete"></i></button>
    </div>';

		// The active article id field.
		if (0 == (int)$this->value) {
			$value = '';
		} else {
			$value = (int)$this->value;
		}

		// class='required' for client side validation
		$class = '';
		if ($this->required) {
			$class = ' class="required modal-value"';
		}

		$html .= '<input type="hidden" id="'.$this->id.'"'.$class.' name="'.$this->name.'" value="'.$value.'" />';

		return $html;
	}

}