<?php
/**
 * @version		2.0.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2015-2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

class com_jxtctimelineInstallerScript {

	
	public function update(JAdapterInstance $adapter) {
		$this->_updateDB();
	}

	public function _updateDB() {
		// Get installation defaults
		
		$dbprefix = JFactory::getApplication()->getCfg('dbprefix');
		$db = JFactory::getDBO();
		
		// Version 1.1
		$table = $dbprefix . "jxtc_timeline_entries";
		$query = 'ALTER TABLE '.$table.' CHANGE `startdate` `startdate` DATETIME NOT NULL, CHANGE `enddate` `enddate` DATETIME NOT NULL';
		$db->setQuery($query);
		if (!$db->query()) { return JError::raiseError(500, $db->getErrorMsg()); }
		
		// Version 2.0
		$table = $dbprefix . "jxtc_timeline_entries";
		$result = $db->getTableColumns($table);
		if (!isset($result['start_year'])) {
			$query = "ALTER TABLE `$table`
		  ADD `start_year` int(4) NOT NULL,
		  ADD `start_month` int(2) NOT NULL,
		  ADD `start_day` int(2) NOT NULL,
		  ADD `start_hour` int(2) NOT NULL,
		  ADD `start_minute` int(2) NOT NULL,
		  ADD `start_second` int(2) NOT NULL,
		  ADD `end_year` int(4) NOT NULL,
		  ADD `end_month` int(2) NOT NULL,
		  ADD `end_day` int(2) NOT NULL,
		  ADD `end_hour` int(2) NOT NULL,
		  ADD `end_minute` int(2) NOT NULL,
		  ADD `end_second` int(2) NOT NULL";
		  $db->setQuery($query);
		  if (!$db->query()) { return JError::raiseError(500, $db->getErrorMsg()); }
		
			$query = "UPDATE `$table` SET
			start_year = date_format(startdate, '%Y'),
			start_month = date_format(startdate, '%c'),
			start_day = date_format(startdate, '%e'),
			start_hour = date_format(startdate, '%k'),
			start_minute = date_format(startdate, '%i'),
			start_second = date_format(startdate, '%s'),
			end_year = date_format(enddate, '%Y'),
			end_month = date_format(enddate, '%c'),
			end_day = date_format(enddate, '%e'),
			end_hour = date_format(enddate, '%k'),
			end_minute = date_format(enddate, '%i'),
			end_second = date_format(enddate, '%s')";
		
		  $db->setQuery($query);
		  if (!$db->query()) { return JError::raiseError(500, $db->getErrorMsg()); }
		}
		
		echo "* Database has been upgraded to version 2.0<br>";
	}
}