<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

class JxtctimelineModelEntries extends JModelList {

	protected $context = 'com_jxtctimeline.entries';

	public function __construct($config = array()) {
		// SET SORTING FIELDS

		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'i.published',
				'entry_startdate',
				'entry_enddate',
				'i.title',
				'i.caption',
				'parent_title',
				'i.id'
			);
		}

		return parent::__construct($config);
	}

	protected function populateState($ordering = null, $direction = null) {
		// SET CUSTOM FILTERS

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$state = $this->getUserStateFromRequest($this->context . '.filter.state', 'filter_state', '', 'string');
		$this->setState('filter.state', $state);

		$state = $this->getUserStateFromRequest($this->context . '.filter.parent', 'filter_parent');
		$this->setState('filter.parent', $state);

		return parent::populateState('i.title', 'asc');
	}

	protected function getListQuery()	{
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		$query->select(
			$this->getState(
				'list.select','i.*'
			)
		);
		$query->select('p.title as parent_title');
		$query->select("CONCAT(lpad(start_year,4,'0'),'/',lpad(start_month,2,'0'),'/',lpad(start_day,2,'0'),' ',lpad(start_hour,2,'0'),':',lpad(start_minute,2,'0'),':',lpad(start_second,2,'0')) AS entry_startdate");
		$query->select("CONCAT(lpad(end_year,4,'0'),'/',lpad(end_month,2,'0'),'/',lpad(end_day,2,'0'),' ',lpad(end_hour,2,'0'),':',lpad(end_minute,2,'0'),':',lpad(end_second,2,'0')) AS entry_enddate");
		$query->from('#__jxtc_timeline_entries AS i');
		$query->from('#__jxtc_timeline AS p');
		$query->where('p.id = i.parent_id');

		// Filter by search in specific fields
		$search = trim($this->getState('filter.search'));
		if (!empty($search)) {
			$search = $db->quote('%'.$search.'%', true);	// quote + escape
			foreach (array('i.title') as $field) { $tmp[] = $db->quoteName($field).' LIKE '.$search; }
			$query->where('('.implode(' OR ',$tmp).')');
		}

		// additional filters
		$value = $this->getState('filter.parent');
		if ($value) {
			$query->where('i.parent_id = '.$db->quote($value));
		}

		// Add the list ordering clause.
		$query->order($db->escape($this->getState('list.ordering', 'i.title')).' '.$db->escape($this->getState('list.direction', 'ASC')));

		//echo str_replace('#__','jos_',$query);

		return $query;
	}

	function getParents()	{
		// get parents list for filtering
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select('id, title');
		$query->from('#__jxtc_timeline');
		$query->order('title');

		if (!$db->setQuery($query)) { JError::raiseError(500, $db->getErrorMsg()); }

		//echo str_replace('#__','jos_',$query);

		$values = $db->loadObjectlist();

		$options = array();
		foreach ($values as $value) {
			$options[] = JHTML::_('select.option', $value->id, $value->title);
		}

		return $options;
	}
}