<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

class JxtctimelineModelTimelines extends JModelList {

	protected $context = 'com_jxtctimeline.timelines';

	public function __construct($config = array()) {
		// SET SORTING FIELDS

		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'i.title',
				'numoptions',
				'i.id'
			);
		}

		return parent::__construct($config);
	}

	protected function populateState($ordering = null, $direction = null) {
		// SET CUSTOM FILTERS

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$state = $this->getUserStateFromRequest($this->context . '.filter.state', 'filter_state', '', 'string');
		$this->setState('filter.state', $state);

		return parent::populateState('i.title', 'asc');
	}

	protected function getListQuery()	{
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		$query->select(
			$this->getState(
				'list.select','i.*'
			)
		);
		$query->from('#__jxtc_timeline AS i');
		$query->select('(SELECT count(*) FROM #__jxtc_timeline_entries AS e WHERE e.parent_id=i.id) AS numoptions');

		// Filter by search in specific fields
		$search = trim($this->getState('filter.search'));
		if (!empty($search)) {
			$search = $db->quote('%'.$search.'%', true);	// quote + escape
			foreach (array('i.title') as $field) { $tmp[] = $db->quoteName($field).' LIKE '.$search; }
			$query->where('('.implode(' OR ',$tmp).')');
		}

		// Add the list ordering clause.
		$query->order($db->escape($this->getState('list.ordering', 'i.title')).' '.$db->escape($this->getState('list.direction', 'ASC')));

		//echo str_replace('#__','jos_',$query);

		return $query;
	}

}




//
//
//
//	function display($tpl=null)	{
//		global $app;
//
//		$db = JFactory::getDBO();
//		$option = JRequest::getCmd( 'option');
//		$filter_order		= $app->getUserStateFromRequest( "$option.filter_order",		'filter_order',		'p.id',	'cmd' );
//		$filter_order_Dir	= $app->getUserStateFromRequest( "$option.filter_order_Dir",	'filter_order_Dir',	'',		'word' );
//		$search				= $app->getUserStateFromRequest( "$option.search",			'search',			'',		'string' );
//		$search				= JString::strtolower( $search );
//
//		$limit		= $app->getUserStateFromRequest( 'global.list.limit', 'limit', $app->getCfg('list_limit'), 'int' );
//		$limitstart	= $app->getUserStateFromRequest( $option.'.limitstart', 'limitstart', 0, 'int' );
//
//		$listtype = $app->getUserStateFromRequest( "$option.listtype", 'listtype', 'p');
//		if ($listtype != 'p') { // Clean filters if coming from other place
//			$filter_order		= 'p.id';
//			$filter_order_Dir	= '';
//			$limitstart = 0;
//		}
//
//		$where = array();
//
//		if ($search) {
//			$where[] = 'LOWER(p.title) LIKE '.$db->Quote( '%'.$db->escape( $search, true ).'%', false );
//		}
//
//		$where 		= ( count( $where ) ? ' WHERE ' . implode( ' AND ', $where ) : '' );
//		$orderby 	= ' ORDER BY '. $filter_order .' '. $filter_order_Dir;
//
//		$query = 'SELECT COUNT(p.id) FROM #__jxtc_timeline AS p '.$where;
//		$db->setQuery( $query );
//		$total = $db->loadResult();
//		if ($db->getErrorNum()) {  JError::raiseError(500, $db->getError() );  }
//
//		jimport('joomla.html.pagination');
//		$pagination = new JPagination( $total, $limitstart, $limit );
//
//		$query = 'SELECT p.*, COUNT(d.id) AS numoptions FROM #__jxtc_timeline AS p LEFT JOIN #__jxtc_timeline_entries AS d ON d.parent_id = p.id'
//		. $where . ' GROUP BY p.id' . $orderby;
//		$db->setQuery( $query, $pagination->limitstart, $pagination->limit );
//		$rows = $db->loadObjectList();
//		if ($db->getErrorNum()) {  JError::raiseError(500, $db->getError() );  }
//
//		// table ordering
//		$lists['order_Dir']	= $filter_order_Dir;
//		$lists['order']		= $filter_order;
//
//		// search filter
//		$lists['search']= $search;
//
//		$this->assign('user',		JFactory::getUser());
//		$this->assignRef('lists',		$lists);
//		$this->assignRef('items',		$rows);
//		$this->assignRef('pagination',	$pagination);
//
//		parent::display($tpl);
//	}
//}