<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

class JxtctimelineViewEntries extends JViewLegacy {

	protected $items;
	protected $pagination;
	protected $state;

	function display($tpl = null) {

		$this->items = $this->get('Items');
		$this->state = $this->get('State');
		$this->pagination = $this->get('Pagination');

		$this->addToolbar();
		$this->addFilters();
		$this->sidebar = JHtmlSidebar::render();

		parent::display($tpl);
	}

	protected function addToolbar() {
		$canDo = JHelperContent::getActions('com_jxtctimeline', 'entry', true);
		$user = JFactory::getUser();

		JToolbarHelper::title(JText::_('JXTCTIMELINE_ENTRIES_HDR'));

		JToolbarHelper::addNew('entry.add');

		if (($canDo->get('core.edit'))) { JToolbarHelper::editList('entry.edit'); }

		if ($canDo->get('core.edit.state')) {
			JToolbarHelper::checkin('entries.checkin');
			JToolbarHelper::publish('entries.publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('entries.unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}

		if (($canDo->get('core.edit'))) {JToolBarHelper::deleteList('', 'entries.delete'); }
	}

	protected function addFilters() {

		// Tag Groups
		$options = $this->get('Parents');

		JHtmlSidebar::addFilter(
			JText::_('JXTCTIMELINE_ENTRIES_FILTER_PARENTS'),
			'filter_parent',
			JHtml::_('select.options', $options, 'value', 'text', $this->state->get('filter.parent'), true)
		);

	}
}