<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

class JxtctimelineViewTimeline extends JViewLegacy {

	function display($tpl = null)	{

		$this->form = $this->get('Form');
		$this->item = $this->get('Item');
		$this->state	= $this->get('State');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));

			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}
	
	protected function addToolbar() {

		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user_id = JFactory::getUser()->get('id');
		$canDo = JHelperContent::getActions('com_jxtctimeline', 'timeline', $this->item->id);

		JToolbarHelper::title(JText::_('JXTCTIMELINE_TIMELINE_HDR'));

		JToolbarHelper::apply('timeline.apply');
		JToolbarHelper::save('timeline.save');
		JToolbarHelper::save2new('timeline.save2new');
		JToolbarHelper::save2copy('timeline.save2copy');
    JToolBarHelper::cancel('timeline.cancel');
	}
}