<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user = JFactory::getUser();
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

$sortFields = array(
	'i.title' => JText::_('JXTCTIMELINE_TIMELINES_TITLE_HDR'),
	'numoptions' => JText::_('JXTCTIMELINE_TIMELINES_ENTRIES_HDR'),
	'i.id' => JText::_('JXTCTIMELINE_TIMELINES_ID_HDR')
);
?>
<script type="text/javascript">
	Joomla.orderTable = function() {
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>') {
			dirn = 'asc';
		}
		else {
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>

<form action="index.php" class="timelines" method="post" name="adminForm" id="adminForm">
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>

	<div id="j-main-container" class="span10">
		<div id="filter-bar">
			<div class="filter-search btn-group pull-left">
				<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" >
			</div>
			<div class="btn-group pull-left">
				<button type="submit" class="btn hasTooltip" title="<?php echo JHtml::tooltipText('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
				<button type="button" class="btn hasTooltip" title="<?php echo JHtml::tooltipText('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
			</div>
			<div class="btn-group pull-right hidden-phone">
				<label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
			<div class="btn-group pull-right hidden-phone">
				<label for="directionTable" class="element-invisible"><?php echo JText::_('JFIELD_ORDERING_DESC');?></label>
				<select name="directionTable" id="directionTable" class="input-medium" onchange="Joomla.orderTable()">
					<option value=""><?php echo JText::_('JFIELD_ORDERING_DESC');?></option>
					<option value="asc" <?php if ($listDirn == 'asc') echo 'selected="selected"'; ?>><?php echo JText::_('JGLOBAL_ORDER_ASCENDING');?></option>
					<option value="desc" <?php if ($listDirn == 'desc') echo 'selected="selected"'; ?>><?php echo JText::_('JGLOBAL_ORDER_DESCENDING');?></option>
				</select>
			</div>
			<div class="btn-group pull-right">
				<label for="sortTable" class="element-invisible"><?php echo JText::_('JGLOBAL_SORT_BY');?></label>
				<select name="sortTable" id="sortTable" class="input-medium" onchange="Joomla.orderTable()">
					<option value=""><?php echo JText::_('JGLOBAL_SORT_BY');?></option>
					<?php echo JHtml::_('select.options', $sortFields, 'value', 'text', $listOrder);?>
				</select>
			</div>
		</div>

		<div class="clearfix"> </div>
	
		<?php if (empty($this->items)) { ?>
			<div class="alert alert-no-items">
				<?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
			</div>
		<?php } else { ?>
			<table class="table table-striped table-hover table-bordered" id="itemList">
				<thead>
					<tr>
						<th width="1%" class="center hidden-phone">
							<?php echo JHtml::_('grid.checkall'); ?>
						</th>
						<th class="title has-context">
							<?php echo JHtml::_('grid.sort', 'JXTCTIMELINE_TIMELINES_TITLE_HDR', 'i.title', $listDirn, $listOrder); ?>
						</th>
						<th width="1%" class="nowrap center hidden-phone">
							<?php echo JHtml::_('grid.sort', 'JXTCTIMELINE_TIMELINES_ENTRIES_HDR', 'numoptions', $listDirn, $listOrder); ?>
						</th>
						<th width="1%" class="nowrap center hidden-phone">
							<?php echo JHtml::_('grid.sort', 'JXTCTIMELINE_TIMELINES_ID_HDR', 'i.id', $listDirn, $listOrder); ?>
						</th>
					</tr>
				</thead>

				<tfoot>
					<tr>
						<td colspan="10">
							<?php echo $this->pagination->getListFooter(); ?>
						</td>
					</tr>
				</tfoot>

				<tbody>
					<?php foreach ($this->items as $i => $item) { ?>
						<?php
							$canCreate  = $user->authorise('core.create',     'com_jxtctimeline.timeline.' . $item->id);
							$canEdit    = $user->authorise('core.edit',       'com_jxtctimeline.timeline.' . $item->id);
							$canCheckin = $user->authorise('core.manage',     'com_checkin') || $item->checked_out == $user->get('id') || $item->checked_out == 0;
							$canChange  = $user->authorise('core.edit.timeline', 'com_jxtctimeline.timeline.' . $item->id) && $canCheckin;
						?>
						<tr> 
							<td class="center hidden-phone">
								<?php echo JHtml::_('grid.id', $i, $item->id); ?>
							</td>
							<td class="nowrap has-context">
								<?php if ($canEdit) { ?><a href="<?php echo JRoute::_('index.php?option=com_jxtctimeline&task=timeline.edit&id='.$item->id); ?>"><?php } ?>
								<?php echo $this->escape($item->title); ?>
								<?php if ($canEdit) { ?></a><?php } ?>
							</td>
							<td class="center hidden-phone">
								<?php echo $item->numoptions; ?>
							</td>
							<td class="center hidden-phone">
								<?php echo $item->id; ?>
							</td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		<?php } ?>
	</div>
	
	<input type="hidden" name="option" value="com_jxtctimeline" />
	<input type="hidden" name="task" value="" >
	<input type="hidden" name="boxchecked" value="0" >
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" >
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" >
	<?php echo JHtml::_('form.token'); ?>
</form>