<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

class JxtctimelineViewTimelines extends JViewLegacy {

	protected $items;
	protected $pagination;
	protected $state;

	function display($tpl = null) {

		$this->items = $this->get('Items');
		$this->state = $this->get('State');
		$this->pagination = $this->get('Pagination');

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();

		parent::display($tpl);
	}

	protected function addToolbar() {
		$canDo = JHelperContent::getActions('com_jxtctimeline', 'timeline', true);
		$user = JFactory::getUser();

		JToolbarHelper::title(JText::_('JXTCTIMELINE_TIMELINES_HDR'));

		JToolbarHelper::addNew('timeline.add');

		if (($canDo->get('core.edit'))) { JToolbarHelper::editList('timeline.edit'); }

		if ($canDo->get('core.edit.state')) { JToolbarHelper::checkin('timelines.checkin'); }

		if (($canDo->get('core.edit'))) { JToolBarHelper::deleteList('', 'timelines.delete'); }
	}
}