<?php
/**
* @package RSEvents!Pro
* @copyright (C) 2015 www.rsjoomla.com
* @license GPL, http://www.gnu.org/copyleft/gpl.html
*/
defined( '_JEXEC' ) or die( 'Restricted access' );

class RseventsproModelDiscount extends JModelAdmin
{
	protected $text_prefix = 'COM_RSEVENTSPRO';

	/**
	 * Returns a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 *
	 * @return	JTable	A database object
	*/
	public function getTable($type = 'Discount', $prefix = 'RseventsproTable', $config = array()) {
		return JTable::getInstance($type, $prefix, $config);
	}
	
	/**
	 * Method to get a single record.
	 *
	 * @param	integer	The id of the primary key.
	 *
	 * @return	mixed	Object on success, false on failure.
	 */
	public function getItem($pk = null) {
		if ($item = parent::getItem($pk)) {
			try {
				$registry = new JRegistry;
				$registry->loadString($item->events);
				$item->events = $registry->toArray();
			} catch (Exception $e) {
				$item->events = array();
			}
			
			try {
				$registry = new JRegistry;
				$registry->loadString($item->groups);
				$item->groups = $registry->toArray();
			} catch (Exception $e) {
				$item->groups = array();
			}
			
			$item->usage = empty($item->usage) ? '' : (int) $item->usage;
			$item->same_tickets = empty($item->same_tickets) ? '' : (int) $item->same_tickets;
			$item->different_tickets = empty($item->different_tickets) ? '' : (int) $item->different_tickets;
			$item->totalvalue = empty($item->totalvalue) ? '' : (float) $item->totalvalue;
		}
		
		return $item;
	}
	
	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		Data for the form.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 *
	 * @return	mixed	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true) {
		// Get the form.
		$form = $this->loadForm('com_rseventspro.discount', 'discount', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form))
			return false;
		
		return $form;
	}
	
	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return	mixed	The data for the form.
	 * @since	1.6
	 */
	protected function loadFormData() {
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_rseventspro.edit.discount.data', array());

		if (empty($data))
			$data = $this->getItem();

		return $data;
	}
}