<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

class JxtctimelineModelJoomla extends JModelAdmin {

	protected $_context = 'com_jxtctimeline.joomla';

	public function tlString($str) {
		$str = json_encode(nl2br($str));
		return substr($str,1,strlen($str)-2);
	}

	public function getForm($data = array(), $loadData = true) {
		return false;
	}

	public function getIntro(&$params) {
		$intro_id = $params->get('introid', 0);

		if (!$intro_id) return false;
		
		$intro = '';
		$db = JFactory::getDBO();
		$query = 'SELECT a.*,
		CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,
		CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug
		FROM #__content a INNER JOIN #__categories AS cc ON cc.id = a.catid
		WHERE a.id='.$intro_id;
		$db->setQuery( $query );
		$row = $db->loadObject();
		if ($db->getErrorNum()) { echo $db->stderr(); return false; }

		if ($params->get('plugins', 0)) {
			JPluginHelper::importPlugin('content');
			$contentconfig = JComponentHelper::getParams('com_content');
			$dispatcher = JDispatcher::getInstance();
			$temp = new stdClass();
			$temp->text = $row->introtext;
			$results = $dispatcher->trigger('onContentPrepare', array('com_content.article', &$temp, &$contentconfig, 0));
			$row->introtext = $temp->text;
		}

	  if ($params->get('readmore', 0)) {
			require_once (JPATH_SITE . '/components/com_content/helpers/route.php');
			$row->introtext .= '<div class="tlreadmore"><a href="' . JRoute::_(ContentHelperRoute::getArticleRoute($row->slug, $row->catslug)) . '">' . JText::_('JXTCTIMELINE_READMORE') . '</a></div>';
	  }

		$intro = array();
		$intro_text = array();
		$intro_media = array();
		
		if ($row->title) $intro_text[] = 'headline:"'.$this->tlString($row->title).'"';
		if ($row->introtext) $intro_text[] = 'text:"'.$this->tlString($row->introtext).'"';
		if ($intro_text) $intro[] = 'text:{'.implode(',',$intro_text).'}';
		
		if ($images = json_decode($row->images)) {
			if ($images->image_intro) $intro_media[] = 'url:"'.JURI::root().$images->image_intro.'"';
			if ($images->image_intro_caption) $intro_media[] = 'caption:"'.$this->tlString($images->image_intro_caption).'"';
			if ($intro_media) $intro[] = 'media:{'.implode(',',$intro_media).'}';
		}
	
		if ($intro) $intro = 'title:{'.implode(',',$intro).'}';

		return $intro;
	}

	public function getItems(&$params) {

		$doPlugins = $params->get('plugins', 0);

		if ($doPlugins) {
			JPluginHelper::importPlugin('content');
			$contentconfig = JComponentHelper::getParams('com_content');
		}

		$db = JFactory::getDBO();

		$categories = (array) $params->get('categories', 0);
		$authors = (array) $params->get('authors', 0);
		$featured = $params->get('featured', 2);
		$archived = $params->get('archived', 1);
		$limit = $params->get('limit', 0);
		$nullDate = $db->Quote($db->getNullDate());
		$nowDate = $db->Quote(JFactory::getDate()->toSQL());

		$query = 'SELECT a.*,
			CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,
			CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug
		FROM #__content a INNER JOIN #__categories AS cc ON cc.id = a.catid
		WHERE (a.publish_up='.$nullDate.' OR a.publish_up <='.$nowDate.')
		  AND (a.publish_down='.$nullDate.' OR a.publish_down >= '.$nowDate.')';

		if ($categories[0] != 0) {
			$query .= ' AND (a.catid='.implode(' OR a.catid=',$categories).')';
		}
		if ($authors[0] != 0) {
			$query .= ' AND (a.created_by='.implode(' OR a.created_by=',$authors).')';
		}
		$query .= $archived ? ' AND a.state>0' : ' AND a.state=1';
		$query .= ' ORDER BY a.publish_up DESC';
		if ($limit) { $query .= ' LIMIT '.$limit; }

		$db->setQuery( $query );
		$items = $db->loadObjectList();
		if ($db->getErrorNum()) { echo $db->stderr(); return false; }

		$customdate = $params->get('customdate');

		$events = array();
		foreach($items as $item) {
			if ($doPlugins) {
				$dispatcher = JDispatcher::getInstance();
				$temp = new stdClass();
				$temp->text = $item->introtext;
				$results = $dispatcher->trigger('onContentPrepare', array('com_content.article', &$temp, &$contentconfig, 0));
				$item->introtext = $temp->text;
			}
		
		  if ($params->get('readmore', 0)) {
				require_once (JPATH_SITE . '/components/com_content/helpers/route.php');
				$item->introtext .= '<div class="tlreadmore"><a href="' . JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug)) . '">' . JText::_('JXTCTIMELINE_READMORE') . '</a></div>';
		  }

			$event = array();
			$event_text = array();
			$event_media = array();
		
			if ($params->get('theme', 'default.css') != 'default.css') $event[] = 'background: {color: "transparent"}';

			if ($item->title) $event_text[] = 'headline:"'.$this->tlString($item->title).'"';
			if ($item->introtext) $event_text[] = 'text:"'.$this->tlString($item->introtext).'"';
			if ($event_text) $event[] = 'text:{'.implode(',',$event_text).'}';
		
			if ($images = json_decode($item->images)) {
				if ($images->image_intro) $event_media[] = 'url:"'.JURI::root().$images->image_intro.'"';
				if ($images->image_intro_caption) $event_media[] = 'caption:"'.$this->tlString($images->image_intro_caption).'"';
				if ($event_media) $event[] = 'media:{'.implode(',',$event_media).'}';
			}
		
			if ($item->publish_up != '0000-00-00 00:00:00') {
				$date = new JDate($item->publish_up);
				$year = $date->format('Y'); $month = $date->format('m'); $day = $date->format('d');
				$hour = $date->format('H'); $minute = $date->format('i'); $second = $date->format('s');
	
				$startdate = array();
				$startdate[] = 'year:"'.$year.'"';
				if ($month) $startdate[] = 'month:"'.$month.'"';
				if ($day) $startdate[] = 'day:"'.$day.'"';
				if ($hour) $startdate[] = 'hour:"'.$hour.'"';
				if ($minute) $startdate[] = 'minute:"'.$minute.'"';
				if ($second) $startdate[] = 'second:"'.$second.'"';
				if ($customdate) { $startdate[] = 'display_date:"'.$date->format($customdate).'"'; }
				$event[] = 'start_date:{'.implode(',',$startdate).'}';
			}
		
			if ($item->publish_down != '0000-00-00 00:00:00') {
				$date = new JDate($item->publish_down);
				$year = $date->format('Y'); $month = $date->format('m'); $day = $date->format('d');
				$hour = $date->format('H'); $minute = $date->format('i'); $second = $date->format('s');
	
				$enddate = array();
				if ($year) $enddate[] = 'year:"'.$year.'"';
				if ($month) $enddate[] = 'month:"'.$month.'"';
				if ($day) $enddate[] = 'day:"'.$day.'"';
				if ($hour) $enddate[] = 'hour:"'.$hour.'"';
				if ($minute) $enddate[] = 'minute:"'.$minute.'"';
				if ($second) $enddate[] = 'second:"'.$second.'"';
				if ($customdate) { $enddate[] = 'display_date:"'.$date->format($customdate).'"'; }
				if ($enddate) $event[] = 'end_date:{'.implode(',',$enddate).'}';
			}
		
			if ($event) {
				$event = '{'.implode(',',$event).'}';
				$events[] = $event;
			}
		}
		$events = implode(',', $events);

		return $events;
	}
}