<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

require_once JPATH_SITE.'/components/com_k2/helpers/route.php';

class JxtctimelineModelK2 extends JModelAdmin {

	protected $_context = 'com_jxtctimeline.k2';

	public function tlString($str) {
		$str = json_encode(nl2br($str));
		return substr($str,1,strlen($str)-2);
	}

	public function getForm($data = array(), $loadData = true) {
		return false;
	}

	function parseItem(&$item, &$k2params) {
	  // Execute K2 plugins
	  
	  $dispatcher = JDispatcher::getInstance();
	
	  // Get Params
	  $iparams = new JRegistry($item->params);
	  $cparams = new JRegistry($item->catparams);
	
	  // Get Params
	  $item->params = $k2params;
	  $item->params->merge($cparams);
	  $item->params->merge($iparams);
	
	  // For SIG Pro Plugin
	  $auxitem = new stdClass();
	  if ($item->gallery) {
	      $k2params->set('galleries_rootfolder', 'media/k2/galleries');
	      $k2params->set('enabledownload', '0');
	      $auxitem->text = $item->gallery;
	      $dispatcher->trigger('onContentPrepare', array('com_k2.item', &$auxitem, &$k2params, 0));
	      $item->gallery = $auxitem->text;
	  }
	
	  // For All Videos Plug
	  if ($item->video) {
	      $k2params->set('afolder', 'media/k2/audio');
	      $k2params->set('vfolder', 'media/k2/videos');
	
	      $k2params->set('vwidth', $item->params->get('itemVideoWidth'));
	      $k2params->set('vheight', $item->params->get('itemVideoHeight'));
	      $k2params->set('autoplay', $item->params->get('itemVideoAutoPlay'));
	
	      $auxitem->text = $item->video;
	      $dispatcher->trigger('onContentPrepare', array('com_k2.item', &$auxitem, &$k2params, 0));
	      $item->video = $auxitem->text;
	  }
	
	  //Get default image
	  $item->image = '';
	  $size = '';
	  switch ($item->params->get('itemImgSize')) {
	      case 'XSmall':
	          $size = 'XS';
	          $item->imageWidth = $item->params->get('itemImageXS');
	          break;
	      case 'Small':
	          $size = 'S';
	          $item->imageWidth = $item->params->get('itemImageS');
	          break;
	      case 'Medium':
	          $size = 'M';
	          $item->imageWidth = $item->params->get('itemImageM');
	          break;
	      case 'Large':
	          $size = 'L';
	          $item->imageWidth = $item->params->get('itemImageL');
	          break;
	      case 'XLarge':
	          $size = 'XL';
	          $item->imageWidth = $item->params->get('itemImageXL');
	          break;
	  }
	
	  if (JFile::exists(JPATH_SITE . '/media/k2/items/cache/' . md5("Image" . $item->id) . '_' . $size . '.jpg') && $item->params->get('itemImage')) {
	      $item->image = JURI::root().'media/k2/items/cache/' . md5("Image" . $item->id) . '_' . $size . '.jpg';
	      $item->imageXLarge = JURI::root().'media/k2/items/cache/' . md5("Image" . $item->id) . '_XL.jpg';
	  }
	}

	public function getIntro(&$params, &$k2params) {
		$intro_id = $params->get('introid', 0);

		if (!$intro_id) return false;
		
		$intro = '';
		$db = JFactory::getDBO();
			$query = 'SELECT a.*, cc.params AS catparams,
			CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,
			CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug
			FROM #__k2_items a INNER JOIN #__k2_categories AS cc ON cc.id = a.catid
			WHERE a.id='.$intro_id;
		$db->setQuery( $query );
		$row = $db->loadObject();
		if ($db->getErrorNum()) { echo $db->stderr(); return false; }

		$this->parseItem($row, $k2params);

		if ($params->get('plugins', 0)) {
			JPluginHelper::importPlugin('content');
			$contentconfig = JComponentHelper::getParams('com_content');
			$dispatcher = JDispatcher::getInstance();
			$temp = new stdClass();
			$temp->text = $row->introtext;
			$results = $dispatcher->trigger('onContentPrepare', array('com_content.article', &$temp, &$contentconfig, 0));
			$row->introtext = $temp->text;
		}

	  if ($params->get('readmore', 0)) {
			$row->introtext .= '<div class="tlreadmore"><a href="' . JRoute::_(K2HelperRoute::getItemRoute($row->slug, $row->catslug)) . '">' . JText::_('JXTCTIMELINE_READMORE') . '</a></div>';
	  }

		$intro = array();
		$intro_text = array();
		$intro_media = array();
		
		if ($row->title) $intro_text[] = 'headline:"'.$this->tlString($row->title).'"';
		if ($row->introtext) $intro_text[] = 'text:"'.$this->tlString($row->introtext).'"';
		if ($intro_text) $intro[] = 'text:{'.implode(',',$intro_text).'}';
		
		if ($row->image) $intro_media[] = 'url:"'.$row->image.'"';
		if ($row->image_caption) $intro_media[] = 'caption:"'.$this->tlString($row->image_caption).'"';
		if ($intro_media) $intro[] = 'media:{'.implode(',',$intro_media).'}';
	
		if ($intro) $intro = 'title:{'.implode(',',$intro).'}';

		return $intro;
	}
	
	public function getItems(&$params, &$k2params) {

		$doPlugins = $params->get('plugins', 0);

		if ($doPlugins) {
			JPluginHelper::importPlugin('content');
			$contentconfig = JComponentHelper::getParams('com_content');
		}

		$db = JFactory::getDBO();

		$categories = (array) $params->get('categories', 0);
		$authors = (array) $params->get('authors', 0);
    $tags = (array) $params->get('tags', 0);
		$featured = $params->get('featured', 2);
		$archived = $params->get('archived', 1);
		$limit = $params->get('limit', 0);

		$nullDate = $db->Quote($db->getNullDate());
		$nowDate = $db->Quote(JFactory::getDate()->toSQL());

    if ($tags[0] != 0) { // Make query for tags
			$query = 'SELECT i.*,
				 CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(":", i.id, i.alias) ELSE i.id END as slug,
				 CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug, cc.params AS catparams
				 FROM #__k2_items i, #__k2_categories cc, #__k2_tags_xref x
				WHERE i.published=1 AND cc.id = i.catid
					AND (i.publish_up=' . $nullDate . ' OR i.publish_up <=' . $nowDate . ')
				  AND (i.publish_down=' . $nullDate . ' OR i.publish_down >= ' . $nowDate . ')
				  AND x.tagID IN (' . join(',', $tags) . ')
				  AND i.id = x.itemID';
		}
		else { // Make query for no tags
			$query = 'SELECT i.*,
				 CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(":", i.id, i.alias) ELSE i.id END as slug,
				 CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug, cc.params AS catparams
				 FROM #__k2_items i, #__k2_categories cc
				WHERE i.published=1 AND cc.id = i.catid
					AND (i.publish_up=' . $nullDate . ' OR i.publish_up <=' . $nowDate . ')
				  AND (i.publish_down=' . $nullDate . ' OR i.publish_down >= ' . $nowDate . ')';
    }

    if ($categories[0] != 0) {
			$query .= ' AND (i.catid=' . implode(' OR i.catid=', $categories) . ')';
    }
    if ($authors[0] != 0) {
			$query .= ' AND (i.created_by=' . implode(' OR i.created_by=', $authors) . ')';
    }
    $query .= ' ORDER BY i.publish_up DESC';
    if ($limit) {
			$query .= ' LIMIT ' . $limit;
    }

		$db->setQuery( $query );
		$items = $db->loadObjectList();
		if ($db->getErrorNum()) { echo $db->stderr(); return false; }

		$customdate = $params->get('customdate');

		$events = array();
		foreach($items as $item) {
			$this->parseItem($item, $k2params);

			if ($doPlugins) {
				$dispatcher = JDispatcher::getInstance();
				$temp = new stdClass();
				$temp->text = $item->introtext;
				$results = $dispatcher->trigger('onContentPrepare', array('com_content.article', &$temp, &$contentconfig, 0));
				$item->introtext = $temp->text;
			}
		
		  if ($params->get('readmore', 0)) {
				$item->introtext .= '<div class="tlreadmore"><a href="' . JRoute::_(K2HelperRoute::getItemRoute($item->slug, $item->catslug)) . '">' . JText::_('JXTCTIMELINE_READMORE') . '</a></div>';
		  }

			$event = array();
			$event_text = array();
			$event_media = array();
		
			if ($params->get('theme', 'default.css') != 'default.css') $event[] = 'background: {"color": "transparent"}';

			if ($item->title) $event_text[] = 'headline:"'.$this->tlString($item->title).'"';
			if ($item->introtext) $event_text[] = 'text:"'.$this->tlString($item->introtext).'"';
			if ($event_text) $event[] = 'text:{'.implode(',',$event_text).'}';
		
			if ($item->image) $event_media[] = 'url:"'.$item->image.'"';
			if ($item->image_caption) $event_media[] = 'caption:"'.$this->tlString($item->image_caption).'"';
			if ($event_media) $event[] = 'media:{'.implode(',',$event_media).'}';
		
			if ($item->publish_up != '0000-00-00 00:00:00') {
				$date = new JDate($item->publish_up);
				$year = $date->format('Y'); $month = $date->format('m'); $day = $date->format('d');
				$hour = $date->format('H'); $minute = $date->format('i'); $second = $date->format('s');
	
				$startdate = array();
				$startdate[] = 'year:"'.$year.'"';
				if ($month) $startdate[] = 'month:"'.$month.'"';
				if ($day) $startdate[] = 'day:"'.$day.'"';
				if ($hour) $startdate[] = 'hour:"'.$hour.'"';
				if ($minute) $startdate[] = 'minute:"'.$minute.'"';
				if ($second) $startdate[] = 'second:"'.$second.'"';
				if ($customdate) { $startdate[] = 'display_date:"'.$date->format($customdate).'"'; }
				$event[] = '"start_date":{'.implode(',',$startdate).'}';
			}
		
			if ($item->publish_down != '0000-00-00 00:00:00') {
				$date = new JDate($item->publish_down);
				$year = $date->format('Y'); $month = $date->format('m'); $day = $date->format('d');
				$hour = $date->format('H'); $minute = $date->format('i'); $second = $date->format('s');
	
				$enddate = array();
				if ($year) $enddate[] = 'year:"'.$year.'"';
				if ($month) $enddate[] = 'month:"'.$month.'"';
				if ($day) $enddate[] = 'day:"'.$day.'"';
				if ($hour) $enddate[] = 'hour:"'.$hour.'"';
				if ($minute) $enddate[] = 'minute:"'.$minute.'"';
				if ($second) $enddate[] = 'second:"'.$second.'"';
				if ($customdate) { $enddate[] = 'display_date:"'.$date->format($customdate).'"'; }
				if ($enddate) $event[] = '"end_date":{'.implode(',',$enddate).'}';
			}
		
			if ($event) {
				$event = '{'.implode(',',$event).'}';
				$events[] = $event;
			}
		}
		$events = implode(',', $events);

		return $events;
	}
}