<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

class JxtctimelineModelTimeline extends JModelAdmin {

	protected $_context = 'com_jxtctimeline.timeline';

	public function getTable($type = 'timeline', $prefix = 'Table', $config = array()) {
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true) {

		return false;
	}

	public function tlString($str) {
		$str = json_encode(nl2br($str));
		return substr($str,1,strlen($str)-2);
	}

	public function getIntro($id, &$params) {
		$db = JFactory::getDBO();
		$query = 'SELECT * FROM #__jxtc_timeline WHERE id=' . (int) $id;
		$db->setQuery( $query );
		$row = $db->loadObject();

		$intro = array();
		$intro_text = array();
		$intro_media = array();
		
		if ($row->headline) $intro_text[] = 'headline:"'.$this->tlString($row->headline).'"';
		if ($row->text) $intro_text[] = 'text:"'.$this->tlString($row->text).'"';
		if ($intro_text) $intro[] = 'text:{'.implode(',',$intro_text).'}';
		
		if ($row->mediaurl) $intro_media[] = 'url:"'.$row->mediaurl.'"';
		if ($row->caption) $intro_media[] = 'caption:"'.$this->tlString($row->caption).'"';
		if ($row->credit) $intro_media[] = 'credit:"'.$this->tlString($row->credit).'"';
		if ($intro_media) $intro[] = 'media:{'.implode(',',$intro_media).'}';
		
		if ($intro) $intro = 'title:{'.implode(',',$intro).'}';

		return $intro;
	}

	public function getItems($id, &$params) {

		$doPlugins = $params->get('plugins', 0);

		if ($doPlugins) {
			JPluginHelper::importPlugin('content');
			$contentconfig = JComponentHelper::getParams('com_content');
		}

		$customdate = $params->get('customdate');

		$db = JFactory::getDBO();
		$query = 'SELECT * FROM #__jxtc_timeline_entries WHERE parent_id='.(int) $id.' AND published=1
		ORDER BY start_year DESC, start_month DESC, start_day DESC, start_hour DESC, start_minute DESC, start_second DESC';
		$db->setQuery( $query );
		$items = $db->loadObjectList();

		$events = array();
		foreach($items as $item) {
			if ($doPlugins) {
				$dispatcher = JDispatcher::getInstance();
				$temp = new stdClass();
				$temp->text = $item->text;
				$results = $dispatcher->trigger('onContentPrepare', array('com_content.article', &$temp, &$contentconfig, 0));
				$item->text = $temp->text;
			}
		
			$event = array();
			$event_text = array();
			$event_media = array();
		
			if ($params->get('theme', 'default.css') != 'default.css') $event[] = 'background: {color: "transparent"}';

			if ($item->title) $event_text[] = 'headline:"'.$this->tlString($item->title).'"';
			if ($item->text) $event_text[] = 'text:"'.$this->tlString($item->text).'"';
			if ($event_text) $event[] = 'text:{'.implode(',',$event_text).'}';
		
			if ($item->mediaurl) $event_media[] = 'url:"'.$item->mediaurl.'"';
			if ($item->caption) $event_media[] = 'caption:"'.$this->tlString($item->caption).'"';
			if ($item->credit) $event_media[] = 'credit:"'.$this->tlString($item->credit).'"';
			if ($event_media) $event[] = 'media:{'.implode(',',$event_media).'}';
		
			$startdate = array();
			$startdate[] = 'year:"'.$item->start_year.'"';
			if ($item->start_month) $startdate[] = 'month:"'.$item->start_month.'"';
			if ($item->start_day) $startdate[] = 'day:"'.$item->start_day.'"';
			if ($item->start_hour) $startdate[] = 'hour:"'.$item->start_hour.'"';
			if ($item->start_minute) $startdate[] = 'minute:"'.$item->start_minute.'"';
			if ($item->start_second) $startdate[] = 'second:"'.$item->start_second.'"';
			if ($customdate) {
				$fecha = sprintf('%04d-%02d-%02d %02d:%02d:%02d',$item->start_year,$item->start_month,$item->start_day,$item->start_hour,$item->start_minute,$item->start_second);
				$date = new JDate($fecha);
				$startdate[] = 'display_date:"'.$date->format($customdate).'"';
			}
			if ($startdate) $event[] = 'start_date:{'.implode(',',$startdate).'}';
		
			$enddate = array();
			if ($item->end_year) $enddate[] = 'year:"'.$item->end_year.'"';
			if ($item->end_month) $enddate[] = 'month:"'.$item->end_month.'"';
			if ($item->end_day) $enddate[] = 'day:"'.$item->end_day.'"';
			if ($item->end_hour) $enddate[] = 'hour:"'.$item->end_hour.'"';
			if ($item->end_minute) $enddate[] = 'minute:"'.$item->end_minute.'"';
			if ($item->end_second) $enddate[] = 'second:"'.$item->end_second.'"';
			if ($customdate) {
				$fecha = sprintf('%04d-%02d-%02d %02d:%02d:%02d',$item->end_year,$item->end_month,$item->end_day,$item->end_hour,$item->end_minute,$item->end_second);
				$date = new JDate($fecha);
				$enddate[] = 'display_date:"'.$date->format($customdate).'"';
			}
			if ($enddate) $event[] = 'end_date:{'.implode(',',$enddate).'}';
		
			if ($event) {
				$event = '{'.implode(',',$event).'}';
				$events[] = $event;
			}
		}
		$events = implode(',', $events);

		return $events;
	}
}