<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

$theme = $this->params->get('theme', 'default.css');
$font = $this->params->get('font', 'font.default.css');
$pageclass_sfx = htmlspecialchars($this->params->get('pageclass_sfx'));
$height = $this->params->get('height', 600);

$googleURL = $this->params->get('url');
$jxtc = uniqid('jxtc');

$document = JFactory::getDocument();
$document->addScript(JURI::root() . 'components/com_jxtctimeline/assets/js/timeline-min.js');
$document->addStyleSheet(JURI::root() . 'components/com_jxtctimeline/assets/css/' . $theme);
$document->addStyleSheet(JURI::root() . 'components/com_jxtctimeline/assets/css/fonts/' . $font);

if (!$this->params->get('date', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-headline-date { display:none; }'); }
if (!$this->params->get('title', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-headline { display:none; }'); }
if (!$this->params->get('navdate', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-slidenav-description { display:none; }'); }
if (!$this->params->get('navtitle', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-slidenav-title { display:none; }'); }

$options = array('language:"'.substr(JFactory::getLanguage()->getTag(), 0, -3).'"');
if ($this->params->get('startend', 0)) { $options[] = 'start_at_end:"true"'; }
if ($this->params->get('startslide', 0)) { $options[] = 'start_at_slide:'.$this->params->get('startslide', 0); }
$options = implode(',', $options);
?>
<div id="jxtctimeline<?php echo $pageclass_sfx; ?>">
	<?php if ($this->params->get('show_page_heading', 1)) { ?>
		<h1>
			<?php
				if ($this->escape($this->params->get('page_heading'))) {
					echo $this->escape($this->params->get('page_heading'));
				} else {
				  echo $this->escape($this->params->get('page_title'));
				}
			?>
		</h1>
	<?php } ?>
	<div id="<?php echo $jxtc; ?>" style="height:<?php echo $height; ?>px"></div>
</div>
<script>
  var <?php echo $jxtc; ?> = new TL.Timeline('<?php echo $jxtc; ?>', '<?php echo $googleURL; ?>', {<?php echo $options; ?>});
	window.onresize = function(event) {
		<?php echo $jxtc; ?>.updateDisplay();
	}
</script>