<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

if (empty($this->items)) {
	echo JText::_('JXTCTIMELINE_NOITEMS');
	return;
}

$theme = $this->params->get('theme', 'default.css');
$font = $this->params->get('font', 'font.default.css');
$pageclass_sfx = htmlspecialchars($this->params->get('pageclass_sfx'));
$height = $this->params->get('height', 600);

$document = JFactory::getDocument();
//$document->addScript(JURI::root() . 'components/com_jxtctimeline/assets/js/timeline-min.js');
$document->addStyleSheet(JURI::root() . 'components/com_jxtctimeline/assets/css/' . $theme);
$document->addStyleSheet(JURI::root() . 'components/com_jxtctimeline/assets/css/fonts/' . $font);

$jxtc = uniqid('jxtc');

if (!$this->params->get('date', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-headline-date { display:none; }'); }
if (!$this->params->get('title', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-headline { display:none; }'); }
if (!$this->params->get('navdate', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-slidenav-description { display:none; }'); }
if (!$this->params->get('navtitle', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-slidenav-title { display:none; }'); }

$options = array('language:"'.substr(JFactory::getLanguage()->getTag(), 0, -3).'"');
if ($this->params->get('startend', 0)) { $options[] = 'start_at_end:"true"'; }
if ($this->params->get('startslide', 0)) { $options[] = 'start_at_slide:'.$this->params->get('startslide', 0); }
$options[] = 'is_embed:true';
//$options[] = 'debug:true';
//$options[] = '"marker_width_min":200';
$options = implode(',', $options);

$tlParams = array();
if ($this->intro) $tlParams[] = $this->intro;
if ($this->items) $tlParams[] = 'events:['.$this->items.']';
if ($tlParams) $tlParams = implode(',',$tlParams);
?>
<div id="jxtctimeline<?php echo $pageclass_sfx; ?>">
	<?php if ($this->params->get('show_page_heading', 1)) { ?>
		<h1>
			<?php
				if ($this->escape($this->params->get('page_heading'))) {
					echo $this->escape($this->params->get('page_heading'));
				} else {
				  echo $this->escape($this->params->get('page_title'));
				}
			?>
		</h1>
	<?php } ?>
	<div id="<?php echo $jxtc; ?>" style="height:<?php echo $height; ?>px"></div>
</div>
<script src="<?php echo JURI::root() . 'components/com_jxtctimeline/assets/js/timeline-min.js';?>"></script>
<script>
	tlparams = <?php echo '{'.$tlParams.'}'; ?>;
  var <?php echo $jxtc; ?> = new TL.Timeline('<?php echo $jxtc; ?>', tlparams, {<?php echo $options; ?>});
	window.onresize = function(event) {
		<?php echo $jxtc; ?>.updateDisplay();
	}
</script>