/**
 * @license
 * =========================================================
 * bootstrap-datetimepicker.js
 * http://www.eyecon.ro/bootstrap-datepicker
 * =========================================================
 * Copyright 2012 Stefan Petre
 *
 * Contributions:
 *  - Andrew Rowls
 *  - Thiago de Arruda
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================================================
 */
(function(e){function t(e){return e.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")}function n(e,t,n){if(t<e.length)return e;else return Array(t-e.length+1).join(n||" ")+e}function r(e,t,n,r,i,s){if(t&&n){return'<div class="bootstrap-datetimepicker-widget dropdown-menu">'+"<ul>"+"<li"+(s?' class="collapse in"':"")+">"+'<div class="datepicker">'+v.template+"</div>"+"</li>"+'<li class="picker-switch accordion-toggle"><a><i class="'+e+'"></i></a></li>'+"<li"+(s?' class="collapse"':"")+">"+'<div class="timepicker">'+m.getTemplate(r,i)+"</div>"+"</li>"+"</ul>"+"</div>"}else if(n){return'<div class="bootstrap-datetimepicker-widget dropdown-menu">'+'<div class="timepicker">'+m.getTemplate(r,i)+"</div>"+"</div>"}else{return'<div class="bootstrap-datetimepicker-widget dropdown-menu">'+'<div class="datepicker">'+v.template+"</div>"+"</div>"}}function i(){return new Date(Date.UTC.apply(Date,arguments))}var s=window.orientation!=undefined;var o=function(e,t){this.id=a++;this.init(e,t)};var u=function(e){if(typeof e==="string"){return new Date(e)}return e};o.prototype={constructor:o,init:function(t,n){var i;if(!(n.pickTime||n.pickDate))throw new Error("Must choose at least one picker");this.options=n;this.$element=e(t);this.language=n.language in f?n.language:"en";this.pickDate=n.pickDate;this.pickTime=n.pickTime;this.isInput=this.$element.is("input");this.component=false;if(this.$element.find(".input-append")||this.$element.find(".input-prepend"))this.component=this.$element.find("button:first");this.format=n.format;this.reset=this.$element.find("button .icon-remove").parent();this.onchangeFnct=this.options.onChangeFnct;this.linkField=n.linkField;if(!this.format){if(this.isInput)this.format=this.$element.data("format");else this.format=this.$element.find("input").data("format");if(!this.format)this.format="MM/dd/yyyy"}this._compileFormat();if(this.component){i=this.component.find("i")}if(this.pickTime){if(i&&i.length)this.timeIcon=i.data("time-icon");if(!this.timeIcon)this.timeIcon="icon-clock";i.addClass(this.timeIcon)}if(this.pickDate){if(i&&i.length)this.dateIcon=i.data("date-icon");if(!this.dateIcon)this.dateIcon="icon-calendar";i.removeClass(this.timeIcon);i.addClass(this.dateIcon)}this.widget=e(r(this.timeIcon,n.pickDate,n.pickTime,n.pick12HourFormat,n.pickSeconds,n.collapse)).appendTo("body");this.minViewMode=n.minViewMode||this.$element.data("date-minviewmode")||0;if(typeof this.minViewMode==="string"){switch(this.minViewMode){case"months":this.minViewMode=1;break;case"years":this.minViewMode=2;break;default:this.minViewMode=0;break}}this.viewMode=n.viewMode||this.$element.data("date-viewmode")||0;if(typeof this.viewMode==="string"){switch(this.viewMode){case"months":this.viewMode=1;break;case"years":this.viewMode=2;break;default:this.viewMode=0;break}}this.startViewMode=this.viewMode;this.weekStart=n.weekStart||this.$element.data("date-weekstart")||0;this.weekEnd=this.weekStart===0?6:this.weekStart-1;this.setStartDate(n.startDate||this.$element.data("date-startdate"));this.setEndDate(n.endDate||this.$element.data("date-enddate"));this.fillDow();this.fillMonths();this.fillHours();this.fillMinutes();this.fillSeconds();this.update();this.showMode();this._attachDatePickerEvents()},show:function(e){this.widget.show();this.height=this.component?this.component.outerHeight():this.$element.outerHeight();this.place();this.$element.trigger({type:"show",date:this._date});this._attachDatePickerGlobalEvents();if(e){e.stopPropagation();e.preventDefault()}},disable:function(){this.$element.find("input").prop("disabled",true);this._detachDatePickerEvents()},enable:function(){this.$element.find("input").prop("disabled",false);this._attachDatePickerEvents()},hide:function(){var e=this.widget.find(".collapse");for(var t=0;t<e.length;t++){var n=e.eq(t).data("collapse");if(n&&n.transitioning)return}this.widget.hide();this.viewMode=this.startViewMode;this.showMode();this.set();this.$element.trigger({type:"hide",date:this._date});this._detachDatePickerGlobalEvents()},set:function(){var t="";if(!this._unset)t=this.formatDate(this._date);if(!this.isInput){if(this.component){var n=this.$element.find("input");n.val(t);this._resetMaskPos(n)}this.$element.data("date",t)}else{this.$element.val(t);this._resetMaskPos(this.$element)}if(this.linkField){e("#"+this.linkField).val(this.formatDateToSql(this._date))}},setValue:function(e){if(!e){this._unset=true}else{this._unset=false}if(typeof e==="string"){this._date=this.parseDate(e)}else if(e){this._date=new Date(e)}this.set();this.viewDate=i(this._date.getUTCFullYear(),this._date.getUTCMonth(),1,0,0,0,0);this.fillDate();this.fillTime()},getDate:function(){if(this._unset)return null;return new Date(this._date.valueOf())},setDate:function(e){if(!e)this.setValue(null);else this.setValue(e.valueOf())},setStartDate:function(e){if(e instanceof Date){this.startDate=e}else if(typeof e==="string"){this.startDate=new i(e);if(!this.startDate.getUTCFullYear()){this.startDate=-Infinity}}else{this.startDate=-Infinity}if(this.viewDate){this.update()}},setEndDate:function(e){if(e instanceof Date){this.endDate=e}else if(typeof e==="string"){this.endDate=new i(e);if(!this.endDate.getUTCFullYear()){this.endDate=Infinity}}else{this.endDate=Infinity}if(this.viewDate){this.update()}},getLocalDate:function(){if(this._unset)return null;var e=this._date;return new Date(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds())},setLocalDate:function(e){if(!e)this.setValue(null);else this.setValue(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()))},place:function(){var t="absolute";var n=this.component?this.component.offset():this.$element.offset();this.width=this.component?this.component.outerWidth():this.$element.outerWidth();n.top=n.top+this.height;var r=e(window);if(this.options.width!=undefined){this.widget.width(this.options.width)}if(this.options.orientation=="left"){this.widget.addClass("left-oriented");n.left=n.left-this.widget.width()+20}if(this._isInFixed()){t="fixed";n.top-=r.scrollTop();n.left-=r.scrollLeft()}if(r.width()<n.left+this.widget.outerWidth()){n.right=r.width()-n.left-this.width;n.left="auto";this.widget.addClass("pull-right")}else{n.right="auto";this.widget.removeClass("pull-right")}this.widget.css({position:t,top:n.top,left:n.left,right:n.right})},notifyChange:function(){this.$element.trigger({type:"changeDate",date:this.getDate(),localDate:this.getLocalDate()});if(typeof this.onchangeFnct=="function"){this.onchangeFnct()}},update:function(e){var t=e;if(!t){if(this.isInput){t=this.$element.val()}else{t=this.$element.find("input").val()}if(t){this._date=this.parseDate(t)}if(!this._date){var n=new Date;this._date=i(n.getFullYear(),n.getMonth(),n.getDate(),n.getHours(),n.getMinutes(),n.getSeconds(),n.getMilliseconds())}}this.viewDate=i(this._date.getUTCFullYear(),this._date.getUTCMonth(),1,0,0,0,0);this.fillDate();this.fillTime()},fillDow:function(){var t=this.weekStart;var n=e("<tr>");while(t<this.weekStart+7){n.append('<th class="dow">'+f[this.language].daysMin[t++%7]+"</th>")}this.widget.find(".datepicker-days thead").append(n)},fillMonths:function(){var e="";var t=0;while(t<12){e+='<span class="month">'+f[this.language].monthsShort[t++]+"</span>"}this.widget.find(".datepicker-months td").append(e)},fillDate:function(){var t=this.viewDate.getUTCFullYear();var n=this.viewDate.getUTCMonth();var r=i(this._date.getUTCFullYear(),this._date.getUTCMonth(),this._date.getUTCDate(),0,0,0,0);var s=typeof this.startDate==="object"?this.startDate.getUTCFullYear():-Infinity;var o=typeof this.startDate==="object"?this.startDate.getUTCMonth():-1;var u=typeof this.endDate==="object"?this.endDate.getUTCFullYear():Infinity;var a=typeof this.endDate==="object"?this.endDate.getUTCMonth():12;this.widget.find(".datepicker-days").find(".disabled").removeClass("disabled");this.widget.find(".datepicker-months").find(".disabled").removeClass("disabled");this.widget.find(".datepicker-years").find(".disabled").removeClass("disabled");this.widget.find(".datepicker-days th:eq(1)").text(f[this.language].months[n]+" "+t);var l=i(t,n-1,28,0,0,0,0);var c=v.getDaysInMonth(l.getUTCFullYear(),l.getUTCMonth());l.setUTCDate(c);l.setUTCDate(c-(l.getUTCDay()-this.weekStart+7)%7);if(t==s&&n<=o||t<s){this.widget.find(".datepicker-days th:eq(0)").addClass("disabled")}if(t==u&&n>=a||t>u){this.widget.find(".datepicker-days th:eq(2)").addClass("disabled")}var h=new Date(l.valueOf());h.setUTCDate(h.getUTCDate()+42);h=h.valueOf();var p=[];var d;var m;while(l.valueOf()<h){if(l.getUTCDay()===this.weekStart){d=e("<tr>");p.push(d)}m="";if(l.getUTCFullYear()<t||l.getUTCFullYear()==t&&l.getUTCMonth()<n){m+=" old"}else if(l.getUTCFullYear()>t||l.getUTCFullYear()==t&&l.getUTCMonth()>n){m+=" new"}if(l.valueOf()===r.valueOf()){m+=" active"}if(l.valueOf()+864e5<=this.startDate){m+=" disabled"}if(l.valueOf()>this.endDate){m+=" disabled"}d.append('<td class="day'+m+'">'+l.getUTCDate()+"</td>");l.setUTCDate(l.getUTCDate()+1)}this.widget.find(".datepicker-days tbody").empty().append(p);var g=this._date.getUTCFullYear();var y=this.widget.find(".datepicker-months").find("th:eq(1)").text(t).end().find("span").removeClass("active");if(g===t){y.eq(this._date.getUTCMonth()).addClass("active")}if(g-1<s){this.widget.find(".datepicker-months th:eq(0)").addClass("disabled")}if(g+1>u){this.widget.find(".datepicker-months th:eq(2)").addClass("disabled")}for(var b=0;b<12;b++){if(t==s&&o>b||t<s){e(y[b]).addClass("disabled")}else if(t==u&&a<b||t>u){e(y[b]).addClass("disabled")}}p="";t=parseInt(t/10,10)*10;var w=this.widget.find(".datepicker-years").find("th:eq(1)").text(t+"-"+(t+9)).end().find("td");this.widget.find(".datepicker-years").find("th").removeClass("disabled");if(s>t){this.widget.find(".datepicker-years").find("th:eq(0)").addClass("disabled")}if(u<t+9){this.widget.find(".datepicker-years").find("th:eq(2)").addClass("disabled")}t-=1;for(var b=-1;b<11;b++){p+='<span class="year'+(b===-1||b===10?" old":"")+(g===t?" active":"")+(t<s||t>u?" disabled":"")+'">'+t+"</span>";t+=1}w.html(p)},fillHours:function(){var e=this.widget.find(".timepicker .timepicker-hours table");e.parent().hide();var t="";if(this.options.pick12HourFormat){var r=1;for(var i=0;i<3;i+=1){t+="<tr>";for(var s=0;s<4;s+=1){var o=r.toString();t+='<td class="hour">'+n(o,2,"0")+"</td>";r++}t+="</tr>"}}else{var r=0;for(var i=0;i<6;i+=1){t+="<tr>";for(var s=0;s<4;s+=1){var o=r.toString();t+='<td class="hour">'+n(o,2,"0")+"</td>";r++}t+="</tr>"}}e.html(t)},fillMinutes:function(){var e=this.widget.find(".timepicker .timepicker-minutes table");e.parent().hide();var t="";var r=0;for(var i=0;i<5;i++){t+="<tr>";for(var s=0;s<4;s+=1){var o=r.toString();t+='<td class="minute">'+n(o,2,"0")+"</td>";r+=3}t+="</tr>"}e.html(t)},fillSeconds:function(){var e=this.widget.find(".timepicker .timepicker-seconds table");e.parent().hide();var t="";var r=0;for(var i=0;i<5;i++){t+="<tr>";for(var s=0;s<4;s+=1){var o=r.toString();t+='<td class="second">'+n(o,2,"0")+"</td>";r+=3}t+="</tr>"}e.html(t)},fillTime:function(){if(!this._date)return;var e=this.widget.find(".timepicker span[data-time-component]");var t=e.closest("table");var r=this.options.pick12HourFormat;var i=this._date.getUTCHours();var s="AM";if(r){if(i>=12)s="PM";if(i===0)i=12;else if(i!=12)i=i%12;this.widget.find(".timepicker [data-action=togglePeriod]").text(s)}i=n(i.toString(),2,"0");var o=n(this._date.getUTCMinutes().toString(),2,"0");var u=n(this._date.getUTCSeconds().toString(),2,"0");e.filter("[data-time-component=hours]").text(i);e.filter("[data-time-component=minutes]").text(o);e.filter("[data-time-component=seconds]").text(u)},click:function(t){t.stopPropagation();t.preventDefault();this._unset=false;var n=e(t.target).closest("span, td, th");if(n.length===1){if(!n.is(".disabled")){switch(n[0].nodeName.toLowerCase()){case"th":switch(n[0].className){case"switch":this.showMode(1);break;case"prev":case"next":var r=this.viewDate;var s=v.modes[this.viewMode].navFnc;var o=v.modes[this.viewMode].navStep;if(n[0].className==="prev")o=o*-1;r["set"+s](r["get"+s]()+o);this.fillDate();this.set();break}break;case"span":if(n.is(".month")){var u=n.parent().find("span").index(n);this.viewDate.setUTCMonth(u)}else{var a=parseInt(n.text(),10)||0;this.viewDate.setUTCFullYear(a)}if(this.viewMode!==0){this._date=i(this.viewDate.getUTCFullYear(),this.viewDate.getUTCMonth(),this.viewDate.getUTCDate(),this._date.getUTCHours(),this._date.getUTCMinutes(),this._date.getUTCSeconds(),this._date.getUTCMilliseconds());this.notifyChange()}this.showMode(-1);this.fillDate();this.set();break;case"td":if(n.is(".day")){var f=parseInt(n.text(),10)||1;var u=this.viewDate.getUTCMonth();var a=this.viewDate.getUTCFullYear();if(n.is(".old")){if(u===0){u=11;a-=1}else{u-=1}}else if(n.is(".new")){if(u==11){u=0;a+=1}else{u+=1}}this._date=i(a,u,f,this._date.getUTCHours(),this._date.getUTCMinutes(),this._date.getUTCSeconds(),this._date.getUTCMilliseconds());this.viewDate=i(a,u,Math.min(28,f),0,0,0,0);this.fillDate();this.set();this.notifyChange()}break}}}},actions:{incrementHours:function(e){this._date.setUTCHours(this._date.getUTCHours()+1)},incrementMinutes:function(e){this._date.setUTCMinutes(this._date.getUTCMinutes()+1)},incrementSeconds:function(e){this._date.setUTCSeconds(this._date.getUTCSeconds()+1)},decrementHours:function(e){this._date.setUTCHours(this._date.getUTCHours()-1)},decrementMinutes:function(e){this._date.setUTCMinutes(this._date.getUTCMinutes()-1)},decrementSeconds:function(e){this._date.setUTCSeconds(this._date.getUTCSeconds()-1)},togglePeriod:function(e){var t=this._date.getUTCHours();if(t>=12)t-=12;else t+=12;this._date.setUTCHours(t)},showPicker:function(){this.widget.find(".timepicker > div:not(.timepicker-picker)").hide();this.widget.find(".timepicker .timepicker-picker").show()},showHours:function(){this.widget.find(".timepicker .timepicker-picker").hide();this.widget.find(".timepicker .timepicker-hours").show()},showMinutes:function(){this.widget.find(".timepicker .timepicker-picker").hide();this.widget.find(".timepicker .timepicker-minutes").show()},showSeconds:function(){this.widget.find(".timepicker .timepicker-picker").hide();this.widget.find(".timepicker .timepicker-seconds").show()},selectHour:function(t){var n=e(t.target);var r=parseInt(n.text(),10);if(this.options.pick12HourFormat){var i=this._date.getUTCHours();if(i>=12){if(r!=12)r=(r+12)%24}else{if(r===12)r=0;else r=r%12}}this._date.setUTCHours(r);this.actions.showPicker.call(this)},selectMinute:function(t){var n=e(t.target);var r=parseInt(n.text(),10);this._date.setUTCMinutes(r);this.actions.showPicker.call(this)},selectSecond:function(t){var n=e(t.target);var r=parseInt(n.text(),10);this._date.setUTCSeconds(r);this.actions.showPicker.call(this)}},doAction:function(t){t.stopPropagation();t.preventDefault();if(!this._date)this._date=i(1970,0,0,0,0,0,0);var n=e(t.currentTarget).data("action");var r=this.actions[n].apply(this,arguments);this.set();this.fillTime();this.notifyChange();return r},stopEvent:function(e){e.stopPropagation();e.preventDefault()},keydown:function(t){var n=this,r=t.which,i=e(t.target);if(r==8||r==46){setTimeout(function(){n._resetMaskPos(i)})}},keypress:function(t){var n=t.which;if(n==8||n==46){return}var r=e(t.target);var i=String.fromCharCode(n);var s=r.val()||"";s+=i;var o=this._mask[this._maskPos];if(!o){return false}if(o.end!=s.length){return}if(!o.pattern.test(s.slice(o.start))){s=s.slice(0,s.length-1);while((o=this._mask[this._maskPos])&&o.character){s+=o.character;this._maskPos++}s+=i;if(o.end!=s.length){r.val(s);return false}else{if(!o.pattern.test(s.slice(o.start))){r.val(s.slice(0,o.start));return false}else{r.val(s);this._maskPos++;return false}}}else{this._maskPos++}},change:function(t){var n=e(t.target);var r=n.val();if(r=="today"){if(this.linkField){e("#"+this.linkField).val(r)}}else if(this._formatPattern.test(r)){this.update();this.setValue(this._date.getTime());this.notifyChange();this.set()}else if(r&&r.trim()){this.setValue(this._date.getTime());if(this._date)this.set();else n.val("")}else{if(this._date){this.setValue(null);this.notifyChange();this._unset=true}}this._resetMaskPos(n)},showMode:function(e){if(e){this.viewMode=Math.max(this.minViewMode,Math.min(2,this.viewMode+e))}this.widget.find(".datepicker > div").hide().filter(".datepicker-"+v.modes[this.viewMode].clsName).show()},destroy:function(){this._detachDatePickerEvents();this._detachDatePickerGlobalEvents();this.widget.remove();this.$element.removeData("datetimepicker");this.component.removeData("datetimepicker")},formatDate:function(e){return this.format.replace(d,function(t){var r,i,s,o=t.length;if(t==="ms")o=1;i=l[t].property;if(i==="Hours12"){s=e.getUTCHours();if(s===0)s=12;else if(s!==12)s=s%12}else if(i==="Period12"){if(e.getUTCHours()>=12)return"PM";else return"AM"}else{r="get"+i;s=e[r]()}if(r==="getUTCMonth")s=s+1;if(r==="getUTCYear")s=s+1900-2e3;return n(s.toString(),o,"0")})},formatDateToSql:function(e){var t="yyyy-MM-dd hh:mm:ss";return t.replace(d,function(t){var r,i,s,o=t.length;if(t==="ms")o=1;i=l[t].property;if(i==="Hours12"){s=e.getUTCHours();if(s===0)s=12;else if(s!==12)s=s%12}else if(i==="Period12"){if(e.getUTCHours()>=12)return"PM";else return"AM"}else{r="get"+i;s=e[r]()}if(r==="getUTCMonth")s=s+1;if(r==="getUTCYear")s=s+1900-2e3;return n(s.toString(),o,"0")})},parseDate:function(e){var t,n,r,i,s,o={};if(!(t=this._formatPattern.exec(e)))return null;for(n=1;n<t.length;n++){r=this._propertiesByIndex[n];if(!r)continue;s=t[n];if(/^\d+$/.test(s))s=parseInt(s,10);o[r]=s}return this._finishParsingDate(o)},_resetMaskPos:function(e){var t=e.val();for(var n=0;n<this._mask.length;n++){if(this._mask[n].end>t.length){this._maskPos=n;break}else if(this._mask[n].end===t.length){this._maskPos=n+1;break}}},_finishParsingDate:function(e){var t,n,r,s,o,u,a;t=e.UTCFullYear;if(e.UTCYear)t=2e3+e.UTCYear;if(!t)t=1970;if(e.UTCMonth)n=e.UTCMonth-1;else n=0;r=e.UTCDate||1;s=e.UTCHours||0;o=e.UTCMinutes||0;u=e.UTCSeconds||0;a=e.UTCMilliseconds||0;if(e.Hours12){s=e.Hours12}if(e.Period12){if(/pm/i.test(e.Period12)){if(s!=12)s=(s+12)%24}else{s=s%12}}return i(t,n,r,s,o,u,a)},_compileFormat:function(){var e,n,r=[],i=[],s=this.format,o={},u=0,a=0;while(e=p.exec(s)){n=e[0];if(n in l){u++;o[u]=l[n].property;r.push("\\s*"+l[n].getPattern(this)+"\\s*");i.push({pattern:new RegExp(l[n].getPattern(this)),property:l[n].property,start:a,end:a+=n.length})}else{r.push(t(n));i.push({pattern:new RegExp(t(n)),character:n,start:a,end:++a})}s=s.slice(n.length)}this._mask=i;this._maskPos=0;this._formatPattern=new RegExp("^\\s*"+r.join("")+"\\s*$");this._propertiesByIndex=o},_attachDatePickerEvents:function(){var t=this;this.widget.on("click",".datepicker *",e.proxy(this.click,this));this.widget.on("click","[data-action]",e.proxy(this.doAction,this));this.widget.on("mousedown",e.proxy(this.stopEvent,this));if(this.pickDate&&this.pickTime){this.widget.on("click.togglePicker",".accordion-toggle",function(n){n.stopPropagation();var r=e(this);var i=r.closest("ul");var s=i.find(".collapse.in");var o=i.find(".collapse:not(.in)");if(s&&s.length){var u=s.data("collapse");if(u&&u.transitioning)return;s.collapse("hide");o.collapse("show");r.find("i").toggleClass(t.timeIcon+" "+t.dateIcon);t.$element.find("button i:first").toggleClass(t.timeIcon+" "+t.dateIcon)}})}if(this.isInput){this.$element.on({focus:e.proxy(this.show,this),change:e.proxy(this.change,this)});if(this.options.maskInput){this.$element.on({keydown:e.proxy(this.keydown,this),keypress:e.proxy(this.keypress,this)})}}else{this.$element.on({change:e.proxy(this.change,this)},"input");if(this.options.maskInput){this.$element.on({keydown:e.proxy(this.keydown,this),keypress:e.proxy(this.keypress,this)},"input")}if(this.component){this.component.on("click",e.proxy(this.show,this))}else{this.$element.on("click",e.proxy(this.show,this))}}if(this.reset){var n=this.linkField;this.reset.on("click",function(){if(n){e("#"+n).val("")}t.$element.find("input").val("");t.notifyChange()})}},_attachDatePickerGlobalEvents:function(){e(window).on("resize.datetimepicker"+this.id,e.proxy(this.place,this));if(!this.isInput){e(document).on("mousedown.datetimepicker"+this.id,e.proxy(this.hide,this))}},_detachDatePickerEvents:function(){this.widget.off("click",".datepicker *",this.click);this.widget.off("click","[data-action]");this.widget.off("mousedown",this.stopEvent);if(this.pickDate&&this.pickTime){this.widget.off("click.togglePicker")}if(this.isInput){this.$element.off({focus:this.show,change:this.change});if(this.options.maskInput){this.$element.off({keydown:this.keydown,keypress:this.keypress})}}else{this.$element.off({change:this.change},"input");if(this.options.maskInput){this.$element.off({keydown:this.keydown,keypress:this.keypress},"input")}if(this.component){this.component.off("click",this.show)}else{this.$element.off("click",this.show)}}},_detachDatePickerGlobalEvents:function(){e(window).off("resize.datetimepicker"+this.id);if(!this.isInput){e(document).off("mousedown.datetimepicker"+this.id)}},_isInFixed:function(){if(this.$element){var t=this.$element.parents();var n=false;for(var r=0;r<t.length;r++){if(e(t[r]).css("position")=="fixed"){n=true;break}}return n}else{return false}}};e.fn.datetimepicker=function(t,n){return this.each(function(){var r=e(this),i=r.data("datetimepicker"),s=typeof t==="object"&&t;if(!i){r.data("datetimepicker",i=new o(this,e.extend({},e.fn.datetimepicker.defaults,s)))}if(typeof t==="string")i[t](n)})};e.fn.datetimepicker.defaults={maskInput:false,pickDate:true,pickTime:true,pick12HourFormat:false,pickSeconds:true,startDate:-Infinity,endDate:Infinity,collapse:true};e.fn.datetimepicker.Constructor=o;var a=0;var f=e.fn.datetimepicker.dates={en:{days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"],daysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sun"],daysMin:["Su","Mo","Tu","We","Th","Fr","Sa","Su"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],monthsShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}};var l={dd:{property:"UTCDate",getPattern:function(){return"(0?[1-9]|[1-2][0-9]|3[0-1])\\b"}},MM:{property:"UTCMonth",getPattern:function(){return"(0?[1-9]|1[0-2])\\b"}},yy:{property:"UTCYear",getPattern:function(){return"(\\d{2})\\b"}},yyyy:{property:"UTCFullYear",getPattern:function(){return"(\\d{4})\\b"}},hh:{property:"UTCHours",getPattern:function(){return"(0?[0-9]|1[0-9]|2[0-3])\\b"}},mm:{property:"UTCMinutes",getPattern:function(){return"(0?[0-9]|[1-5][0-9])\\b"}},ss:{property:"UTCSeconds",getPattern:function(){return"(0?[0-9]|[1-5][0-9])\\b"}},ms:{property:"UTCMilliseconds",getPattern:function(){return"([0-9]{1,3})\\b"}},HH:{property:"Hours12",getPattern:function(){return"(0?[1-9]|1[0-2])\\b"}},PP:{property:"Period12",getPattern:function(){return"(AM|PM|am|pm|Am|aM|Pm|pM)\\b"}}};var c=[];for(var h in l)c.push(h);c[c.length-1]+="\\b";c.push(".");var p=new RegExp(c.join("\\b|"));c.pop();var d=new RegExp(c.join("\\b|"),"g");var v={modes:[{clsName:"days",navFnc:"UTCMonth",navStep:1},{clsName:"months",navFnc:"UTCFullYear",navStep:1},{clsName:"years",navFnc:"UTCFullYear",navStep:10}],isLeapYear:function(e){return e%4===0&&e%100!==0||e%400===0},getDaysInMonth:function(e,t){return[31,v.isLeapYear(e)?29:28,31,30,31,30,31,31,30,31,30,31][t]},headTemplate:"<thead>"+"<tr>"+'<th class="prev">&lsaquo;</th>'+'<th colspan="5" class="switch"></th>'+'<th class="next">&rsaquo;</th>'+"</tr>"+"</thead>",contTemplate:'<tbody><tr><td colspan="7"></td></tr></tbody>'};v.template='<div class="datepicker-days">'+'<table class="table-condensed">'+v.headTemplate+"<tbody></tbody>"+"</table>"+"</div>"+'<div class="datepicker-months">'+'<table class="table-condensed">'+v.headTemplate+v.contTemplate+"</table>"+"</div>"+'<div class="datepicker-years">'+'<table class="table-condensed">'+v.headTemplate+v.contTemplate+"</table>"+"</div>";var m={hourTemplate:'<span data-action="showHours" data-time-component="hours" class="timepicker-hour"></span>',minuteTemplate:'<span data-action="showMinutes" data-time-component="minutes" class="timepicker-minute"></span>',secondTemplate:'<span data-action="showSeconds" data-time-component="seconds" class="timepicker-second"></span>'};m.getTemplate=function(e,t){return'<div class="timepicker-picker">'+'<table class="table-condensed"'+(e?' data-hour-format="12"':"")+">"+"<tr>"+'<td><a href="#" class="btn" data-action="incrementHours"><i class="icon-chevron-up"></i></a></td>'+'<td class="separator"></td>'+'<td><a href="#" class="btn" data-action="incrementMinutes"><i class="icon-chevron-up"></i></a></td>'+(t?'<td class="separator"></td>'+'<td><a href="#" class="btn" data-action="incrementSeconds"><i class="icon-chevron-up"></i></a></td>':"")+(e?'<td class="separator"></td>':"")+"</tr>"+"<tr>"+"<td>"+m.hourTemplate+"</td> "+'<td class="separator">:</td>'+"<td>"+m.minuteTemplate+"</td> "+(t?'<td class="separator">:</td>'+"<td>"+m.secondTemplate+"</td>":"")+(e?'<td class="separator"></td>'+"<td>"+'<button type="button" class="btn btn-primary" data-action="togglePeriod"></button>'+"</td>":"")+"</tr>"+"<tr>"+'<td><a href="#" class="btn" data-action="decrementHours"><i class="icon-chevron-down"></i></a></td>'+'<td class="separator"></td>'+'<td><a href="#" class="btn" data-action="decrementMinutes"><i class="icon-chevron-down"></i></a></td>'+(t?'<td class="separator"></td>'+'<td><a href="#" class="btn" data-action="decrementSeconds"><i class="icon-chevron-down"></i></a></td>':"")+(e?'<td class="separator"></td>':"")+"</tr>"+"</table>"+"</div>"+'<div class="timepicker-hours" data-action="selectHour">'+'<table class="table-condensed">'+"</table>"+"</div>"+'<div class="timepicker-minutes" data-action="selectMinute">'+'<table class="table-condensed">'+"</table>"+"</div>"+(t?'<div class="timepicker-seconds" data-action="selectSecond">'+'<table class="table-condensed">'+"</table>"+"</div>":"")}})(window.jQuery)