<?php
/**
 * @version		2.2.1
 * @package		JoomlaXTC Timeline for Joomla 3.x
 * @author		JoomlaXTC http://www.joomlaxtc.com
 * @copyright	Copyright (C) 2016 Monev Software LLC. All rights reserved.
 * @license		http://opensource.org/licenses/GPL-2.0 GNU Public License, version 2.0
 */

defined( '_JEXEC' ) or die;

if (empty($items)) {
	echo JText::_('JXTCTIMELINE_NOITEMS');
	return;
}

$theme = $params->get('theme', 'default.css');
$font = $params->get('font', 'font.default.css');
$pageclass_sfx = htmlspecialchars($params->get('pageclass_sfx'));
$height = $params->get('height', 600);

$document = JFactory::getDocument();
$document->addScript(JURI::root() . 'components/com_jxtctimeline/assets/js/timeline-min.js');
$document->addStyleSheet(JURI::root() . 'components/com_jxtctimeline/assets/css/' . $theme);
$document->addStyleSheet(JURI::root() . 'components/com_jxtctimeline/assets/css/fonts/' . $font);

$jxtc = uniqid('jxtc');

if (!$params->get('date', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-headline-date { display:none; }'); }
if (!$params->get('title', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-headline { display:none; }'); }
if (!$params->get('navdate', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-slidenav-description { display:none; }'); }
if (!$params->get('navtitle', 1)) { $document->addStyleDeclaration('#'.$jxtc.' .tl-slidenav-title { display:none; }'); }

$options = array('language:"'.substr(JFactory::getLanguage()->getTag(), 0, -3).'"');
if ($params->get('startend', 0)) { $options[] = 'start_at_end:"true"'; }
if ($params->get('startslide', 0)) { $options[] = 'start_at_slide:'.$params->get('startslide', 0); }
$options = implode(',', $options);

$tlParams = array();
if ($intro) $tlParams[] = $intro;
if ($items) $tlParams[] = '"events":['.$items.']';
if ($tlParams) $tlParams = implode(',',$tlParams);
?>
<div id="jxtctimeline<?php echo $pageclass_sfx; ?>">
	<div id="<?php echo $jxtc; ?>" style="height:<?php echo $height; ?>px"></div>
</div>
<script>
	tlparams = <?php echo '{'.$tlParams.'}'; ?>;
  var <?php echo $jxtc; ?> = new TL.Timeline('<?php echo $jxtc; ?>', tlparams, {<?php echo $options; ?>});
	window.onresize = function(event) {
		<?php echo $jxtc; ?>.updateDisplay();
	}
</script>